inherit systemd

FILESEXTRAPATHS_prepend := "${THISDIR}/${PN}:"
SRC_URI += "file://btHciUartSetting.sh \
            file://bt-hciuart.service \
            file://btHciUartStop.sh \
            file://nvm_tlv_3.2_baud2M.bin \
            file://rampatch_tlv_3.2.tlv \
            ${@bb.utils.contains('PREFERRED_VERSION_bluez5', '5.82', '','file://0005-ble-xbox-privacy-device.patch',d)} \
            ${@bb.utils.contains('DISTRO_FEATURES', 'dunfell', 'file://bluez-5.54.patch','file://bluez-5.45.patch',d)} \
            ${@bb.utils.contains('DISTRO_FEATURES', 'dunfell', 'file://bluetooth_service_in_xi6_dunfell.patch','file://bluetooth_service_in_xi6.patch',d)} \
            "

do_install_append() {
    install -m 0755 ${WORKDIR}/btHciUartSetting.sh ${D}${bindir}/btHciUartSetting.sh
    install -m 0755 ${WORKDIR}/btHciUartStop.sh ${D}${bindir}/btHciUartStop.sh
    install -m 0644 ${WORKDIR}/bt-hciuart.service ${D}${systemd_unitdir}/system

    install -d ${D}/lib/firmware/
    install -m 0644 ${WORKDIR}/nvm_tlv_3.2_baud2M.bin ${D}/lib/firmware/
    install -m 0644 ${WORKDIR}/rampatch_tlv_3.2.tlv ${D}/lib/firmware/
}

FILES_${PN} += " /lib/firmware/*"
SYSTEMD_SERVICE_${PN} += " bt-hciuart.service"
